/*
 * Decompiled with CFR 0.152.
 */
package crystalspider.torchhit.handler;

import crystalspider.torchhit.config.TorchHitConfig;
import crystalspider.torchhit.optional.SoulFired;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.piglin.AbstractPiglin;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(modid="torchhit", bus=Mod.EventBusSubscriber.Bus.FORGE)
public final class LivingAttackEventHandler {
    private static final Supplier<Boolean> isSoulfiredInstalled = () -> ModList.get().isLoaded("soulfired");

    @SubscribeEvent
    public static void handle(LivingAttackEvent event) {
        InteractionHand interactionHand;
        LivingEntity target;
        LivingEntity attacker;
        Entity entity = event.getSource().m_7639_();
        Entity directEntity = event.getSource().m_7640_();
        if (entity instanceof LivingEntity && entity == directEntity && !entity.f_19853_.f_46443_ && !entity.m_5833_() && LivingAttackEventHandler.canAttack(attacker = (LivingEntity)entity, target = event.getEntity()) && (interactionHand = LivingAttackEventHandler.getInteractionHand(attacker)) != null && !target.m_5825_()) {
            boolean directHit;
            ItemStack item = attacker.m_21120_(interactionHand);
            boolean bl = directHit = interactionHand == InteractionHand.MAIN_HAND;
            if (directHit || LivingAttackEventHandler.isAllowedTool(attacker.m_21205_().m_41720_())) {
                LivingAttackEventHandler.attack(attacker, (Entity)target, item, directHit);
            }
        }
    }

    private static void attack(LivingEntity attacker, Entity target, ItemStack item, boolean directHit) {
        LivingAttackEventHandler.consumeItem(attacker, item, directHit, LivingAttackEventHandler.burn(target, item, directHit ? TorchHitConfig.getDirectHitDuration() : TorchHitConfig.getIndirectHitDuration()));
    }

    private static void consumeItem(LivingEntity attacker, ItemStack item, boolean directHit, int fireSeconds) {
        if ((!(attacker instanceof Player) || !((Player)attacker).m_7500_()) && (LivingAttackEventHandler.isCandle(item) && TorchHitConfig.getConsumeCandle().booleanValue() || LivingAttackEventHandler.isTorch(item) && TorchHitConfig.getConsumeTorch().booleanValue()) && (directHit || TorchHitConfig.getConsumeWithIndirectHits().booleanValue()) && (TorchHitConfig.getConsumeWithoutFire().booleanValue() || fireSeconds > 0)) {
            item.m_41774_(1);
        }
    }

    private static int burn(Entity target, ItemStack item, int defaultDuration) {
        int fireSeconds = LivingAttackEventHandler.getFireSeconds(item, target, defaultDuration);
        if (fireSeconds > 0) {
            if (isSoulfiredInstalled.get().booleanValue()) {
                SoulFired.setOnFire(target, fireSeconds, LivingAttackEventHandler.isSoulTorch(item));
            } else {
                target.m_20254_(fireSeconds);
            }
        }
        return fireSeconds;
    }

    private static int getFireSeconds(ItemStack item, Entity target, int fireDuration) {
        if (Math.random() * 100.0 < (double)TorchHitConfig.getFireChance().intValue()) {
            if (LivingAttackEventHandler.isSoulTorch(item)) {
                if (isSoulfiredInstalled.get().booleanValue()) {
                    return fireDuration;
                }
                if (target instanceof AbstractPiglin) {
                    return fireDuration * 2;
                }
                return fireDuration + 1;
            }
            return fireDuration;
        }
        return 0;
    }

    private static boolean isAllowedTool(Item item) {
        return !TorchHitConfig.getIndirectHitToolList().isEmpty() && TorchHitConfig.getIndirectHitToolList().stream().filter(toolType -> LivingAttackEventHandler.getKey(item).matches(".*:([^_]+_)*" + toolType + "(_[^_]+)*")).count() > 0L;
    }

    @Nullable
    private static InteractionHand getInteractionHand(LivingEntity attacker) {
        if (LivingAttackEventHandler.isValidItem(attacker.m_21205_())) {
            return InteractionHand.MAIN_HAND;
        }
        if (LivingAttackEventHandler.isValidItem(attacker.m_21206_())) {
            return InteractionHand.OFF_HAND;
        }
        return null;
    }

    private static boolean isValidItem(ItemStack item) {
        return LivingAttackEventHandler.isTorch(item) || LivingAttackEventHandler.isCandle(item);
    }

    private static boolean isTorch(ItemStack item) {
        return item.m_150930_(Items.f_42000_) && TorchHitConfig.getVanillaTorchesEnabled() != false || TorchHitConfig.getExtraTorchItems().contains(LivingAttackEventHandler.getKey(item.m_41720_())) || LivingAttackEventHandler.isSoulTorch(item);
    }

    private static boolean isSoulTorch(ItemStack item) {
        return item.m_150930_(Items.f_42053_) && TorchHitConfig.getVanillaTorchesEnabled() != false || TorchHitConfig.getExtraSoulTorchItems().contains(LivingAttackEventHandler.getKey(item.m_41720_()));
    }

    private static boolean isCandle(ItemStack item) {
        return TorchHitConfig.getAllowCandles() != false && item.m_204117_(ItemTags.f_144319_);
    }

    private static boolean canAttack(LivingEntity attacker, LivingEntity target) {
        return !(!(attacker instanceof Player) && TorchHitConfig.getFireFromMobs() == false || !attacker.m_6779_(target) || attacker instanceof Player && target instanceof Player && !((Player)attacker).m_7099_((Player)target));
    }

    private static String getKey(Item item) {
        ResourceLocation itemLocation = ForgeRegistries.ITEMS.getKey((Object)item);
        if (itemLocation != null) {
            return itemLocation.toString();
        }
        return "";
    }
}

